package sk.kosice.konto.kkmessageservice.repository.subscription;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Test;
import sk.kosice.konto.kkmessageservice.domain.subscription.data.ImmutableDeleteSubscriptionsByOrganizationIdAndKidData;

public class JooqSubscriptionDeleteTest extends JooqSubscriptionRepositoryTest {

  @Test
  public void thatSubscriptionsAreDeletedByOrganizationIdAndKid() {
    final List<UUID> topics = prepareTopics();
    final UUID recipientKid1 = prepareRecipient();
    final UUID recipientKid2 = prepareRecipient();
    prepareSubscriptions(recipientKid1, topics.toArray(UUID[]::new));
    prepareSubscriptions(recipientKid2, topics.toArray(UUID[]::new));

    final var result1 = findSubscriptions(subscriptionRepository, recipientKid1);
    assertThat(result1).isNotNull().isNotEmpty().hasSize(3);
    final var result2 = findSubscriptions(subscriptionRepository, recipientKid2);
    assertThat(result2).isNotNull().isNotEmpty().hasSize(3);

    deleteSubscriptionsByOrganizationIdAndKid(
        subscriptionRepository,
        ImmutableDeleteSubscriptionsByOrganizationIdAndKidData.builder()
            .recipientKid(recipientKid1)
            .rsqlQuery(rsqlParser.parse("organizationId==" + ORGANIZATION_ID))
            .build());

    final var updatedResult1 = findSubscriptions(subscriptionRepository, recipientKid1);
    assertThat(updatedResult1).isNotNull().isEmpty();
    final var updatedResult2 = findSubscriptions(subscriptionRepository, recipientKid2);
    assertThat(updatedResult2).isNotNull().isNotEmpty().hasSize(3);
  }
}
