package sk.kosice.konto.kkmessageservice.repository.topic;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ImmutableListOrdering;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ImmutablePageSize;
import sk.kosice.konto.kkmessageservice.domain.common.listing.TopicListingAttribute;
import sk.kosice.konto.kkmessageservice.domain.topic.data.DeleteTopicData;
import sk.kosice.konto.kkmessageservice.domain.topic.data.ImmutableDeleteTopicData;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.ImmutableTopicEntity;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.ListOfTopics;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.TopicEntity;
import sk.kosice.konto.kkmessageservice.domain.topic.query.FindTopicByIdQuery;
import sk.kosice.konto.kkmessageservice.domain.topic.query.ImmutableTopicListingQuery;
import sk.kosice.konto.kkmessageservice.domain.topic.query.TopicListingQuery;

public interface JooqTopicRepositoryTestSupport {

  default ImmutableTopicEntity prepareTopicData() {
    return ImmutableTopicEntity.builder()
        .id(UUID.randomUUID())
        .name("name")
        .description("description")
        .organizationId(UUID.randomUUID())
        .organizationName("organizationName")
        .build();
  }

  default ImmutableTopicEntity prepareUpdateTopicData(UUID id, UUID organizationId) {
    return ImmutableTopicEntity.builder()
        .id(id)
        .name("nameUpdated")
        .description("descriptionUpdated")
        .organizationId(organizationId)
        .organizationName("organizationName")
        .build();
  }

  default DeleteTopicData prepareDeleteTopicData(UUID id, UUID organizationId) {
    return ImmutableDeleteTopicData.builder().organizationId(organizationId).id(id).build();
  }

  default void deleteTopic(JooqTopicRepository repository, DeleteTopicData deleteData) {
    repository.delete(deleteData);
  }

  default void updateTopic(JooqTopicRepository repository, TopicEntity updateData) {
    repository.update(updateData);
  }

  default void persistTopic(JooqTopicRepository repository, TopicEntity insertData) {
    repository.insert(insertData);
  }

  default TopicEntity findTopic(JooqTopicRepository repository, FindTopicByIdQuery query) {
    return repository.findOne(query);
  }

  default TopicEntity persistAndFindTopic(JooqTopicRepository repository, TopicEntity insertData) {
    persistTopic(repository, insertData);
    return findTopic(repository, FindTopicByIdQuery.of(insertData));
  }

  default ListOfTopics listTopics(JooqTopicRepository repository, UUID organizationId) {
    final TopicListingQuery query =
        ImmutableTopicListingQuery.builder()
            .pageSize(ImmutablePageSize.of(100))
            .organizationId(organizationId)
            .addAllOrderings(List.of(ImmutableListOrdering.of(TopicListingAttribute.NAME, true)))
            .rsqlQuery(Optional.empty())
            .build();
    return repository.list(query);
  }
}
