package sk.kosice.konto.kkmessageservice.restapi.command;

import java.util.Optional;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.common.audit.ImmutableActorIdentity;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ListFiltering;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ListOrderings;
import sk.kosice.konto.kkmessageservice.domain.common.listing.MessageListingAttribute;
import sk.kosice.konto.kkmessageservice.domain.common.listing.PageSize;
import sk.kosice.konto.kkmessageservice.domain.message.query.ImmutableMessageListingQuery;
import sk.kosice.konto.kkmessageservice.domain.message.query.MessageListingQuery;

public final class MessageQueryFactory {

  public static MessageListingQuery map(
      UUID recipientKid,
      UUID organizationId,
      Optional<String> actorId,
      ListFiltering<MessageListingAttribute> filter,
      ListOrderings<MessageListingAttribute> orderings,
      Integer page,
      Integer pageSize,
      Integer maxPageSize) {
    return ImmutableMessageListingQuery.builder()
        .pageSize(PageSize.of(maxPageSize, pageSize))
        .addAllOrderings(orderings.asList())
        .rsqlQuery(filter.asOption())
        .page(page)
        .recipientKid(Optional.ofNullable(recipientKid))
        .organizationId(Optional.ofNullable(organizationId))
        .actorId(actorId.map(ImmutableActorIdentity::of))
        .build();
  }
}
