package sk.kosice.konto.kkmessageservice.restapi.command;

import java.util.Optional;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ImmutablePageSize;
import sk.kosice.konto.kkmessageservice.domain.organization.query.ImmutableOrganizationListingQuery;
import sk.kosice.konto.kkmessageservice.domain.organization.query.OrganizationListingQuery;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.FindSubscribedOrganizationsByKidQuery;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.ImmutableFindSubscribedOrganizationsByKidQuery;

public class OrganizationQueryFactory {

  public static OrganizationListingQuery map(Optional<UUID> rootOrganizationId) {
    return ImmutableOrganizationListingQuery.builder()
        .pageSize(ImmutablePageSize.of(10))
        .rootOrganizationId(rootOrganizationId)
        .build();
  }

  public static FindSubscribedOrganizationsByKidQuery map(UUID kid) {
    return ImmutableFindSubscribedOrganizationsByKidQuery.builder().recipientKid(kid).build();
  }
}
