package sk.kosice.konto.kkmessageservice.restapi.mapper;

import java.util.stream.Collectors;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.ListOfTopics;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.TopicEntity;
import sk.kosice.konto.kkmessageservice.restapi.dto.topic.ImmutableTopicDetailResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.topic.ImmutableTopicListResponse;
import sk.kosice.konto.kkmessageservice.restapi.dto.topic.TopicListResponse;

public final class TopicResponseMapper {

  public static ImmutableTopicDetailResponse map(TopicEntity entity) {
    return ImmutableTopicDetailResponse.builder()
        .name(entity.name())
        .description(entity.description())
        .id(entity.id())
        .organizationId(entity.organizationId())
        .build();
  }

  public static TopicListResponse map(ListOfTopics list) {
    return ImmutableTopicListResponse.builder()
        .totalCount(list.totalCount())
        .page(list.page())
        .pageSize(list.pageSize())
        .addAllItems(
            list.items().stream().map(TopicResponseMapper::map).collect(Collectors.toList()))
        .build();
  }
}
