package sk.kosice.konto.kkmessageservice.business.subscription.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.subscription.port.inbound.BatchUpdateSubscriptionUseCase;
import sk.kosice.konto.kkmessageservice.business.subscription.port.outbound.PersistSubscriptionPort;
import sk.kosice.konto.kkmessageservice.business.subscription.port.outbound.QuerySubscriptionPort;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ImmutablePageSize;
import sk.kosice.konto.kkmessageservice.domain.subscription.command.BatchUpdateSubscriptionCommand;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.BaseSubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.ImmutableBaseSubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.SubscriptionEntity;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.FindSubscriptionByIdQuery;
import sk.kosice.konto.kkmessageservice.domain.subscription.query.ImmutableSubscriptionListingQuery;

@Named
public class BatchUpdateSubscriptionService extends AbstractService
    implements BatchUpdateSubscriptionUseCase {

  private final QuerySubscriptionPort querySubscriptionPort;
  private final PersistSubscriptionPort persistSubscriptionPort;

  @Inject
  public BatchUpdateSubscriptionService(
      QuerySubscriptionPort querySubscriptionPort,
      PersistSubscriptionPort persistSubscriptionPort) {
    this.querySubscriptionPort = querySubscriptionPort;
    this.persistSubscriptionPort = persistSubscriptionPort;
  }

  @Override
  public List<SubscriptionEntity> execute(BatchUpdateSubscriptionCommand command) {
    command
        .subscriptions()
        .forEach(
            s ->
                querySubscriptionPort.findOne(
                    FindSubscriptionByIdQuery.of(s.id(), command.recipientKid())));

    persistSubscriptionPort.batchUpdate(
        command.subscriptions().stream()
            .map(
                s ->
                    (BaseSubscriptionEntity)
                        ImmutableBaseSubscriptionEntity.builder()
                            .id(s.id())
                            .isEmailEnabled(s.isEmailEnabled())
                            .build())
            .toList());

    return querySubscriptionPort.listWithoutPaging(
        ImmutableSubscriptionListingQuery.builder()
            .pageSize(ImmutablePageSize.of(100))
            .recipientKid(command.recipientKid())
            .build());
  }
}
