package sk.kosice.konto.kkmessageservice.business.topic.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.topic.port.inbound.ListTopicUseCase;
import sk.kosice.konto.kkmessageservice.business.topic.port.outbound.QueryTopicPort;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.ListOfTopics;
import sk.kosice.konto.kkmessageservice.domain.topic.query.TopicListingQuery;

@Named
public class ListTopicService extends AbstractService implements ListTopicUseCase {

  private final QueryTopicPort queryTopicPort;

  @Inject
  public ListTopicService(QueryTopicPort queryTopicPort) {
    this.queryTopicPort = queryTopicPort;
  }

  @Override
  public ListOfTopics execute(TopicListingQuery query) {
    return queryTopicPort.list(query);
  }
}
