package sk.kosice.konto.kkmessageservice.business.topic.service;

import jakarta.inject.Named;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.organization.port.outbound.QueryOrganizationPort;
import sk.kosice.konto.kkmessageservice.business.topic.port.inbound.SynchronizeTopicOrganizationNameUseCase;
import sk.kosice.konto.kkmessageservice.business.topic.port.outbound.PersistTopicPort;
import sk.kosice.konto.kkmessageservice.business.topic.port.outbound.QueryTopicPort;
import sk.kosice.konto.kkmessageservice.domain.common.listing.PageSize;
import sk.kosice.konto.kkmessageservice.domain.organization.entity.OrganizationEntity;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.ImmutableTopicEntity;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.TopicEntity;
import sk.kosice.konto.kkmessageservice.domain.topic.query.ImmutableTopicListingQuery;

@Named
public class SynchronizeTopicOrganizationNameService extends AbstractService
    implements SynchronizeTopicOrganizationNameUseCase {

  private final QueryTopicPort queryTopicPort;
  private final PersistTopicPort persistTopicPort;
  private final QueryOrganizationPort queryOrganizationPort;

  @Autowired
  public SynchronizeTopicOrganizationNameService(
      QueryTopicPort queryTopicPort,
      PersistTopicPort persistTopicPort,
      QueryOrganizationPort queryOrganizationPort) {
    this.queryTopicPort = queryTopicPort;
    this.persistTopicPort = persistTopicPort;
    this.queryOrganizationPort = queryOrganizationPort;
  }

  @Override
  public void execute() {
    final var organizations = queryOrganizationPort.list(Optional.empty());

    for (var org : organizations) {
      var topics =
          queryTopicPort.list(
              ImmutableTopicListingQuery.builder()
                  .pageSize(PageSize.of(Integer.MAX_VALUE, Integer.MAX_VALUE))
                  .organizationId(org.id())
                  .page(1)
                  .build());
      checkOrganizationNames(topics.items(), org);
    }
  }

  private void checkOrganizationNames(List<TopicEntity> topics, OrganizationEntity organization) {
    for (var topic : topics) {
      final var topicOrganizationName = topic.organizationName();

      if (!topicOrganizationName.equals(organization.name())) {
        persistTopicPort.update(
            ImmutableTopicEntity.builder()
                .id(topic.id())
                .name(topic.name())
                .description(topic.description())
                .organizationId(topic.organizationId())
                .organizationName(organization.name())
                .build());
      }
    }
  }
}
