package sk.kosice.konto.kkmessageservice.domain.businessconfig;

import org.immutables.value.Value;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.Role;

@Value.Immutable
public interface BusinessConfig {

  String adminRoleId();

  String adminGlobalRoleId();

  default String getRoleIdByName(Role name) {
    return switch (name) {
      case ADMIN -> adminRoleId();
      case ADMIN_GLOBAL -> adminGlobalRoleId();
    };
  }
}
