package sk.kosice.konto.kkmessageservice.domain.message.command;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Value;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.BodyType;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.Location;
import sk.kosice.konto.kkmessageservice.domain.common.marker.AuditableCommand;

@Value.Immutable
public interface CreateMessageCommand extends AuditableCommand {

  String title();

  UUID topicId();

  String body();

  Optional<String> tags();

  UUID organizationId();

  Optional<UUID> recipientKid();

  BodyType bodyType();

  String bodyShort();

  Optional<String> actions();

  List<Location> locations();
}
