import React from 'react';
import { cn, Organization } from '@/utils';
import { CheckCircleIcon, ChevronRightIcon, BaseButton } from '@/lib/idsk';

interface OrganizationsListItemProps {
  organization: Organization;
  isActive: boolean;
  onClick: () => void;
}

const OrganizationsListItem: React.FC<OrganizationsListItemProps> = ({ organization, isActive, onClick }) => {
  return (
    <BaseButton
      className={cn(
        'bg-white rounded-md border border-neutral-300 text-left py-3 px-4 flex justify-between items-center gap-4 hover:border-black whitespace-normal',
        { 'border-primary-medium bg-primary-light': isActive }
      )}
      onClick={onClick}
    >
      <div className="w-full flex flex-col">
        <b>{organization.name}</b>
        <span className="text-neutral-600 text-sm">{organization.description}</span>
      </div>
      <div className="idsk-text-body">
        {isActive ? <CheckCircleIcon className="flex-shrink-0" /> : <ChevronRightIcon className="flex-shrink-0" />}
      </div>
    </BaseButton>
  );
};

export default OrganizationsListItem;
