'use client';

import { cn } from '@/utils';
import { usePathname } from 'next/navigation';
import Link from 'next/link';

interface NavigationLinkProps {
  href: string;
  children: string;
}

export const NavigationLink: React.FC<NavigationLinkProps> = ({ href, children }) => {
  const pathname = usePathname();
  const isActive = pathname.includes(href);

  return (
    <li>
      <Link
        href={href}
        className={cn('idsk-text-body inline-block p-4 w-full rounded-none hover:bg-blue-100', {
          'bg-blue-100 border-l-[5px] border-blue-500 font-bold text-blue-500': isActive
        })}
      >
        {children}
      </Link>
    </li>
  );
};
