import { NextRequest, NextResponse } from 'next/server';
import { auth } from './auth';

const publicPages = ['/signin', '/error', '/prihlasenie'];

export default async function middleware(req: NextRequest) {
  const session = await auth();

  const isLogged = !!session;
  const path = req.nextUrl.pathname;

  if (!isLogged && !publicPages.includes(path)) {
    return NextResponse.redirect(new URL(`/prihlasenie`, req.url));
  }

  if (isLogged && path === '/prihlasenie') {
    return NextResponse.redirect(new URL(`/spravy`, req.url));
  }

  return NextResponse.next();
}

export const config = {
  matcher: ['/', '/(sk|en)/:path*', '/((?!api|_next/static|_next/image|favicon.ico).*)']
};
