export interface Fault {
  serviceId: string;
  faultCode: string;
  faultMessage: string;
  faultMessageFormat: string[];
}

export interface ApiError {
  correlationId: string;
  fault: Fault[];
}

export interface SimpleApiError {
  correlationId: string;
  serviceId: string;
  faultCode: string;
  faultMessage: string;
  faultMessageParams: string[];
}

export type RequestError = {
  status: number;
  statusText: string;
  message: string;
  correlationId: string;
  fault: Fault[];
};

export type Ok<T> = {
  data: T;
  error: undefined;
};

export type Err = {
  status: number;
  data: undefined;
  error: RequestError;
};

export type Result<T> = Ok<T> | Err;

export type Page<T> = {
  items: T[];
  page: number;
  pageSize: number;
  totalCount: number;
};

export type Items<T> = {
  items: T[];
};

export type PermissionType = 'ACTION_MANAGE_MESSAGE' | 'ACTION_MANAGE_TOPIC';

export interface IUser {
  oid: string;
  name: string;
  email: string;
  organization?: Organization;
  permissions: PermissionType[];
}

export interface Identity {
  kid: string;
  qaaReg: string;
  pin: string;
  category: string;
  emails: string[];
  emailPreferred?: string;
  phonePreferred?: string;
  phones: string[];
  givenName: string;
  surname: string;
  title: string;
  ibans: string[];
  created: number;
  modified: number;
  expRegCode: number;
  isActive: boolean;
}

export interface Address {
  aid: string;
  type: string;
  street1: string;
  censusNumber: string;
  orientationNumber: string;
  city: string;
  state: string;
  postalCode: string;
  created: number;
  modified: number;
  isActive: boolean;
}

export interface MessageTag {
  color: string;
  value: string;
}

export interface MessageActionMetadata {
  id: string;
  type: string;
  key: string;
  value: string;
}

export interface MessageAction {
  title: string;
  desc: string;
  type: string | number;
  value: string;
  metadata: MessageActionMetadata[];
}

export interface Message {
  id: string;
  senderName: string;
  title: string;
  topic: {
    id: string;
    name: string;
  };
  tags: MessageTag[];
  createdAt: string;
  recipientKid: string | null;
  actions?: MessageAction[];
}

export interface NewMessage {
  title: string;
  topicId: string;
  tags: MessageTag[];
  bodyType: string;
  body: string;
  bodyShort: string;
  actions: any[];
}

export interface Topic {
  name: string;
  description: string;
  id: string;
  organizationId: string;
}

export interface NewTopic {
  name: string;
  description: string;
}

export interface Organization {
  id: string;
  name: string;
  description: string;
  isCityDistrict: boolean;
}

export interface Permission {
  organization: Organization;
  permissions: PermissionType[];
}
