package sk.kosice.konto.kknotificationservice.config;

import javax.sql.DataSource;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import sk.kosice.konto.kknotificationservice.business.businessconfig.BusinessConfigProvider;
import sk.kosice.konto.kknotificationservice.config.properties.SpringBusinessProperties;

@Configuration
public class BeanConfiguration {

  private static final String DEFAULT_TABLE_NAME = "SHEDLOCK";

  @Bean
  public BusinessConfigProvider businessConfigProvider(SpringBusinessProperties springConfig) {
    return new BusinessConfigProvider(springConfig.buildBusinessConfig());
  }

  @Bean
  public LockProvider lockProvider(
      DataSource dataSource,
      @Value("${sk.kosice.notification.scheduler.schema}") String schemaName) {
    return new JdbcTemplateLockProvider(
        JdbcTemplateLockProvider.Configuration.builder()
            .withJdbcTemplate(new JdbcTemplate(dataSource))
            .withTableName(schemaName + "." + DEFAULT_TABLE_NAME)
            .usingDbTime()
            .build());
  }
}
