package sk.kosice.konto.kknotificationservice.config.properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import sk.kosice.konto.kknotificationservice.config.error.BusinessConfigErrorCode;
import sk.kosice.konto.kknotificationservice.domain.businessconfig.BusinessConfig;
import sk.kosice.konto.kknotificationservice.domain.businessconfig.ImmutableBusinessConfig;

@Configuration(proxyBeanMethods = false)
public class SpringBusinessProperties {
  @Value("${sk.kosice.notification.mailjet.sender-email}")
  public String senderEmail;

  @Value("${sk.kosice.notification.mailjet.sender-name}")
  public String senderName;

  @Value("${sk.kosice.notification.scheduler.email-sender.messages-limit}")
  public Integer messagesLimit;

  @Value("${sk.kosice.notification.check-permissions.admin-role-id}")
  public String adminRoleId;

  private static final Logger log = LoggerFactory.getLogger(SpringBusinessProperties.class);

  public BusinessConfig buildBusinessConfig() {
    if (senderEmail == null) {
      log.error("sk.kosice.notification.mailjet.sender-email is not defined in config file.");
      throw BusinessConfigErrorCode.UNDEFINED_EMAIL_SENDER.createError().convertToException();
    }

    if (senderName == null) {
      log.error("sk.kosice.notification.mailjet.sender-name is not defined in config file.");
      throw BusinessConfigErrorCode.UNDEFINED_EMAIL_SENDER_NAME.createError().convertToException();
    }

    if (messagesLimit == null) {
      log.error(
          "sk.kosice.notification.scheduler.email-sender.messages-limit is not defined in config file.");
      throw BusinessConfigErrorCode.UNDEFINED_MESSAGES_LIMIT.createError().convertToException();
    }

    if (adminRoleId == null) {
      log.error("sk.kosice.message.check-permissions.admin-role-id is not defined in config file.");
      throw BusinessConfigErrorCode.UNDEFINED_ADMIN_ROLE_ID.createError().convertToException();
    }

    return ImmutableBusinessConfig.builder()
        .senderEmail(senderEmail)
        .senderName(senderName)
        .messagesLimit(messagesLimit)
        .adminRoleId(adminRoleId)
        .build();
  }

  public String getSenderEmail() {
    return senderEmail;
  }

  public void setSenderEmail(String senderEmail) {
    this.senderEmail = senderEmail;
  }

  public String getSenderName() {
    return senderName;
  }

  public void setSenderName(String senderName) {
    this.senderName = senderName;
  }

  public String getAdminRoleId() {
    return adminRoleId;
  }

  public void setAdminRoleId(String adminRoleId) {
    this.adminRoleId = adminRoleId;
  }
}
