import { providerCache, getPolicy, Provider } from '@/lib/auth/credentials';
import { redirect } from 'next/navigation';
import { NextRequest } from 'next/server';

const getAuthorizeUri = (provider: Provider, redirectUri: string, locale: string) => {
  providerCache.set(provider);
  const currentPolicy = getPolicy(provider);

  const authorizeUrl = new URL(process.env.AZURE_AD_AUTH_URL as string);
  authorizeUrl.searchParams.set('p', currentPolicy);
  authorizeUrl.searchParams.set('scope', process.env.AZURE_AD_SCOPE as string);
  authorizeUrl.searchParams.set('client_id', process.env.AZURE_AD_CLIENT_ID as string);
  authorizeUrl.searchParams.set('redirect_uri', redirectUri);
  authorizeUrl.searchParams.set('ui_locales', locale);
  authorizeUrl.searchParams.set('prompt', 'select_account');
  authorizeUrl.searchParams.set('response_type', 'code');

  return authorizeUrl.toString();
};

export const GET = (req: NextRequest) => {
  const url = new URL(req.url);
  const provider = url.searchParams.get('provider');
  const locale = url.searchParams.get('ui_locales') || 'sk';
  const redirectUri = `${req.headers.get('x-forwarded-proto')}://${req.headers.get('host')}/api/auth/token`;
  const authorizeUri = getAuthorizeUri((provider as Provider) || 'microsoft-entra-id', redirectUri, locale);

  redirect(authorizeUri);
};
