'use client';

import React, { useMemo } from 'react';
import QRCode from 'react-qr-code';
import { CurrencyCode, DataModel, encode, PaymentOptions } from 'bysquare';
import { v4 } from 'uuid';
import { useTranslations } from 'next-intl';
import { MessageAction } from '@/utils';

interface PayBySquareActionProps {
  action: MessageAction;
}

const PayBySquareAction: React.FC<PayBySquareActionProps> = ({ action }) => {
  const t = useTranslations('messages');

  const qrCode = useMemo(() => {
    if (!action.metadata) return null;

    const data = {
      invoiceId: v4(),
      payments: [
        {
          type: PaymentOptions.PaymentOrder,
          currencyCode: CurrencyCode.EUR,
          amount: Number(action.metadata.find((item) => item.type === 'PRICE')?.value || 0),
          variableSymbol: action.metadata.find((item) => item.type === 'VARIABLE_SYMBOL')?.value || '',
          specificSymbol: action.metadata.find((item) => item.type === 'SPECIFIC_SYMBOL')?.value || '',
          constantSymbol: action.metadata.find((item) => item.type === 'CONSTANT_SYMBOL')?.value || '',
          bankAccounts: [{ iban: action.metadata.find((item) => item.type === 'IBAN')?.value || '' }],
          beneficiary: {
            name: action.metadata.find((item) => item.type === 'RECIPIENT_NAME')?.value || ''
          }
        }
      ]
    } satisfies DataModel;

    return encode(data);
  }, [action]);

  return (
    <div>
      <h4 className="mb-3">{t('payment_for_service')}</h4>
      <div className="p-5 rounded bg-neutral-90 border border-neutral-300">
        <h4 className="mb-5">{action.title}</h4>
        <p className="w-8/12">{action.desc}</p>

        <div className="mt-10 gap-8 flex flex-col tb2:flex-row justify-between">
          <div className="w-full">
            {action.metadata?.map((metadata: any, index: number) => (
              <p key={`${metadata.id}-${metadata.type}-${index}`}>
                <span>{metadata.key}</span> <b>{metadata.value}</b>
              </p>
            ))}
          </div>
          {qrCode && (
            <div className="flex items-center justify-center w-full">
              <QRCode size={160} value={qrCode} />
            </div>
          )}
        </div>
      </div>
    </div>
  );
};
export default PayBySquareAction;
