'use client';

import React from 'react';
import { PageLayout } from '@/lib/idsk';
import Header from './Header';
import Footer from './Footer';
import SessionExpiredDialog from './SessionExpiredDialog';
import SessionErrorBanner from './SessionErrorBanner';

interface LayoutProps {
  children: React.ReactNode;
}

const Layout: React.FC<LayoutProps> = ({ children }) => (
  <PageLayout
    header={<Header />}
    footer={<Footer />}
    informationBannerPosition="bottom"
    informationBanner={<SessionErrorBanner />}
  >
    <SessionExpiredDialog />
    {children}
  </PageLayout>
);

export default Layout;
