'use client';

import React from 'react';
import { useSession } from 'next-auth/react';
import { Error } from '../core';
import { getRequestError, isRequestError } from '@/utils/api/error';

const SessionErrorBanner = () => {
  const session = useSession();

  if (session.data && session.data.error && session.data.error !== 'RefreshTokenError') {
    let error = session.data.error as any;
    if (!isRequestError(error)) {
      error = getRequestError(error);
    }
    return <Error err={error} asBanner type="announcement" />;
  }

  return null;
};

export default SessionErrorBanner;
