'use client';

import React, { useMemo, useState } from 'react';
import { SnackbarProps, SnackbarStack } from '@/lib/idsk';
import { NotificationsContext } from '@/context';

interface NotificationsProviderProps {
  children: React.ReactNode;
}

type Notification = Omit<SnackbarProps, 'open'>;

const NotificationsProvider: React.FC<NotificationsProviderProps> = ({ children }) => {
  const [notifications, setNotifications] = useState<SnackbarProps[]>([]);

  const notify = (notification: string | Notification) => {
    const snackbar: SnackbarProps = {
      open: true,
      autoHideDuration: 6000,
      closeButton: true,
      ...(typeof notification === 'string' ? { message: notification } : notification)
    };
    setNotifications((prevNotifications) => [...prevNotifications, snackbar]);
  };

  const contextValue = useMemo(
    () => ({
      notifications,
      notify
    }),
    [notifications]
  );

  return (
    <NotificationsContext.Provider value={contextValue}>
      {children}
      <SnackbarStack snackbars={notifications} setSnackbars={setNotifications} />
    </NotificationsContext.Provider>
  );
};

export default NotificationsProvider;
