/**
 * Detail component.
 *
 * @author: Vaclav Hradec <vaclav@mihybrid.com>
 *
 */

'use strict';

import Detail from "mihbbtv/lib/components/detail";
import Button from "mihbbtv/lib/components/button";
import Image from "mihbbtv/lib/components/image";
import Sanitize from "mihbbtv/lib/util/sanitize";
import Item from "../models/item";

class AppDetail extends Detail {

  isFocusable() {
    return false;
  }

  itemMarkup(item) {
    this.config.link = {
      id: item.id,
      type: item.type,
    };
    
    return Button.markup({
      id: this.container + 'Back',
      class: ((this.isActive) ? ' active' : ''),
      title: item.buttonTitle
    }) +
    ((item.img) ?
    Image.markup({
      src: item.img,
      rounded: {
        tl: true,
        tr: true,
        bl: true,
        br: true,
      }
    }) : '') +
    ((item.imgChannel) ? ('<div id="' + this.container + 'ImgChannel" class="imgChannel"><img id="' + this.container + 'ImgChannelElm" src="' + item.imgChannel + '" /></div>') : '') +
    '<div id="' + this.container + 'Text" class="text">' +
      '<h2 id="' + this.container + 'TextTitle">' +
        item.title +
      '</h2><p id="' + this.container + 'TextDescription">' +
        ((item.description) ? Sanitize.html(item.description, 315) : '') +
    '</p></div>';
  }

  enterItem(app, scene) {
    return Item.enterItem(this.config.link, app, scene);
  }

}

export default AppDetail;
