/**
 * Detail scene.
 *
 * @author: Vaclav Hradec <vaclav@mihybrid.com>
 */
 'use strict';

import App from "mihbbtv/lib/hbbtv/application";
import BaseScene from "mihbbtv/lib/hbbtv/application/scene/base";
import ActsFactory from "mihbbtv/lib/hbbtv/application/act/factory";
import LocalComponents from "../components";
import Api from "../api";

class DetailScene extends BaseScene {

  constructor(name, acts) {
    super(name, acts);

    this.keyset = 0x1 + 0x8 + 0x10 + 0x20;
    this.defaultAct = null;
    this.implicitScroller = true;
  }

  /**
   * Show scene.
   *
   * @param {Integer} prev
   * @param {Function} done
   * @returns {void}
   */
  show(prev, done) {
    super.show(prev);

    const load = (data) => {
      ActsFactory.build(this, data, LocalComponents, (App.config.menu) ? 1 : 0);

      // automatically set default act
      if (null === this.defaultAct) {
        this.defaultAct = this.incAct();
      }

      App.loader.hide();
      App.mainMenu.clearMutex();

      return done();
    };

    if (this.params && this.params.pagination) {
      Api.direct(this.params.pagination.url, load);

      // console.log(`delete components`, this.acts);

      // delete components in the same scene
      for (let i = 0; i < this.acts.length; i++) {
        delete this.acts[i].component;
      }
      this.defaultAct = null;

      // pagination scroll to top
      if (this.scroller) {
        this.scroller.startY();
      }

    } else {
      if (! (this.params && this.params.detail)) {
        this.params.detail = {
          type: 'detail'
        }
      }

      // this.params.detail.id = 'ee6095c0-33ac-3526-b8bf-df233af38211';

      Api.detail(this.params.detail.type, [
        {
          name: 'id',
          value: this.params.detail.id,
        },
        {
          name: 'type',
          value: this.params.detail.type,
        },
      ], load);
    }
  }
}

export default DetailScene;
