/**
 * About scene.
 *
 * @author: Vaclav Hradec <vaclav@mihybrid.com>
 */
'use strict';

import App from "mihbbtv/lib/hbbtv/application";
import Scene from "mihbbtv/lib/hbbtv/application/scene";
import KeyHandler from "mihbbtv/lib/hbbtv/keyHandler";

import acts from './acts';

class AboutScene extends Scene {

  constructor() {
    super();

    this.handle = 'about';
    this.keyset = 0x1 + 0x8 + 0x10 + 0x100;
    this.anim = Scene.ANIMATIONS.FADE;
    this.animDuration = 0.5;
    this.addActs(acts);
    this.overlay = true;

    this.enteringScene = null;
  }

  /**
  * Show scene.
  *
  * @param {Integer} prev
  * @returns {void}
  */
  show(prev, done) {
    this.enteringScene = prev;
    if (this.elm) {
      this.elm.style.zIndex = 101;
    }

    return done();
  }

  /**
   * Hide scene.
   *
   * @returns {void}
   */
   hide() {
     if (this.elm) {
       this.elm.style.zIndex = 0;
     }
  }
}

export default AboutScene;
