/**
 * Parent AppScene scene.
 *
 * @author: Vaclav Hradec <vaclav@mihybrid.com>
 */
 'use strict';

import App from "mihbbtv/lib/hbbtv/application";
import BaseScene from "mihbbtv/lib/hbbtv/application/scene/base";
import ActsFactory from "mihbbtv/lib/hbbtv/application/act/factory";
import LocalComponents from "../components";
import SessionManager from "../models/sessions";
import ComponentAct from "./componentAct";
import Api from "../api";

class AppScene extends BaseScene {

  constructor(name, acts) {
    super(name, acts);

    this.keyset = 0x1 + 0x8 + 0x10 + 0x20;

    SessionManager.initMenu(App.mainMenu);
  }

  /**
   * Show scene.
   *
   * @param {Integer} prev
   * @param {Function} done
   * @returns {void}
   */
  show(prev, done) {
    super.show(prev);

    const load = (data) => {
      ActsFactory.setActClass(ComponentAct);
      ActsFactory.build(this, data, LocalComponents, (App.config.menu) ? 1 : 0);

      this.changeBg(data.config);

      // console.log(this.params);

      App.loader.hide();
      App.mainMenu.clearMutex();

      return done();
    };

    // use cache if hit
    if ('home' === this.handle && App.cache && App.cache[this.handle]) {
      load(App.cache[this.handle]);
      delete App.cache[this.handle];
    } else if ('login' === this.handle) {
      Api.login(this.getFilterParams(this.params), load);
    } else if ('logout' === this.handle) {
      SessionManager.logOut();
      SessionManager.initMenu(App.mainMenu);
      Api.mainItem('home', this.getFilterParams(this.params), load);
    } else if ('profile' === this.handle) {
      const profile = SessionManager.getProfile();

      if (profile) {
        Api.direct(profile.favouriteUrl, load);
      } else {
        SessionManager.logOut();
        SessionManager.initMenu(App.mainMenu);
      }
    } else {
      // load scene's data
      Api.mainItem(this.handle, this.getFilterParams(this.params), load);
    }

  }

  getFilterParams(prms) {
    const result = [];

    if (prms.filter) {
      if (prms.filter.label) {
        result.push({
          name: 'filterLabel',
          value: prms.filter.label,
        });
      }

      result.push({
        name: 'filterValue',
        value: prms.filter.value,
      });
      result.push({
        name: 'filterType',
        value: prms.filter.type,
      });
      result.push({
        name: 'filterIndex',
        value: prms.filter.index,
      });
    }

    return result;
  }

}

export default AppScene;
