import type { Metadata } from 'next';
import '@/styles/index.css';
import { auth } from '@/auth';
import { Providers } from '@/components';

export const metadata: Metadata = {
  title: 'Správca Košice',
  description: 'Generated by create next app'
};

export default async function LoginLayout({
  children
}: Readonly<{
  children: React.ReactNode;
}>) {
  const session = await auth();

  return (
    <html lang="sk">
      <body className="bg-neutral-100 w-screen min-h-[100vh] flex flex-col gap-2 justify-center items-center">
        <Providers session={session}>{children}</Providers>
      </body>
    </html>
  );
}
