package sk.kosice.konto.kkmessageservice.idp.mapper;

import com.microsoft.graph.models.Group;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.organization.entity.ImmutableOrganizationEntity;
import sk.kosice.konto.kkmessageservice.domain.organization.entity.OrganizationEntity;

public class AzureIdpMapper {

  public static OrganizationEntity map(Group group) {
    return ImmutableOrganizationEntity.builder()
        .id(UUID.fromString(group.getId()))
        .isCityDistrict(group.getDisplayName().contains("-cd-"))
        .name(group.getDisplayName().replace("kk-", "").replace("cd-", ""))
        .description(Optional.ofNullable(group.getDescription()))
        .build();
  }

  public static List<OrganizationEntity> map(List<Group> groups) {
    if (groups == null) {
      return List.of();
    }

    return groups.stream().map(AzureIdpMapper::map).toList();
  }
}
