package sk.kosice.konto.kkmessageservice.repository.recipient;

import static sk.kosice.konto.kkmessageservice.domain.recipient.error.RecipientErrorCode.RECIPIENT_DOES_NOT_EXIST;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.RECIPIENT;
import static sk.kosice.konto.kkmessageservice.repository.recipient.mapper.JooqRecipientRepositoryMapper.recipientRecordMapper;

import java.util.UUID;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import sk.kosice.konto.kkmessageservice.domain.common.error.BusinessException;
import sk.kosice.konto.kkmessageservice.domain.recipient.entity.RecipientEntity;
import sk.kosice.konto.kkmessageservice.repository.JooqRepository;
import sk.kosice.konto.kkmessageservice.repository.recipient.error.constraint.RecipientConstraintErrorCode;

@Repository
public class JooqRecipientRepository extends JooqRepository implements RecipientRepositoryAdapter {

  @Autowired
  protected JooqRecipientRepository(DSLContext dslContext) {
    super(dslContext);
  }

  @Override
  public void insert(RecipientEntity data) throws BusinessException {
    log.info("Applying {}", data);

    handleInsertResult(
        () ->
            dslContext
                .insertInto(RECIPIENT)
                .set(RECIPIENT.KID, data.kid())
                .set(RECIPIENT.EMAIL, data.email())
                .execute(),
        data,
        RecipientConstraintErrorCode.values());
  }

  @Override
  public RecipientEntity findOne(UUID kid) throws BusinessException {
    log.info("Applying {}", kid);

    return handleFindOneResult(
        () ->
            dslContext
                .selectFrom(RECIPIENT)
                .where(RECIPIENT.KID.eq(kid))
                .fetch(recipientRecordMapper()),
        kid,
        RecipientConstraintErrorCode.values());
  }

  @Override
  protected void createEntityDoesNotExistError(Object id) {
    throw RECIPIENT_DOES_NOT_EXIST.createError(id).convertToException();
  }
}
