package sk.kosice.konto.kkmessageservice.repository.rsql.jooq.handler;

import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.RSQLParserException;
import cz.jirutka.rsql.parser.ast.Node;
import jakarta.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sk.kosice.konto.kkmessageservice.business.rsql.RsqlHandler;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ListFilteringOperators;
import sk.kosice.konto.kkmessageservice.repository.rsql.RsqlErrorCode;

@Named
public class JooqRsqlParserHandler implements RsqlHandler {
  private static final Logger log = LoggerFactory.getLogger(JooqRsqlParserHandler.class);
  private static final RSQLParser rsqlParser = new RSQLParser(ListFilteringOperators.all());

  @Override
  public Node parse(String query) {
    try {
      return rsqlParser.parse(query);
    } catch (RSQLParserException e) {
      log.error(e.getMessage(), e);
      throw RsqlErrorCode.PARSE_RSQL_EXCEPTION.createError().convertToException();
    }
  }
}
