package sk.kosice.konto.kkmessageservice.repository;

import cz.jirutka.rsql.parser.RSQLParser;
import java.util.UUID;
import org.jooq.DSLContext;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import sk.kosice.konto.kkmessageservice.domain.common.listing.ListFilteringOperators;
import sk.kosice.konto.kkmessageservice.repository.message.JooqMessageRepository;
import sk.kosice.konto.kkmessageservice.repository.model.Tables;
import sk.kosice.konto.kkmessageservice.repository.recipient.JooqRecipientRepository;
import sk.kosice.konto.kkmessageservice.repository.subscription.JooqSubscriptionRepository;
import sk.kosice.konto.kkmessageservice.repository.topic.JooqTopicRepository;

@ExtendWith(SpringExtension.class)
@SpringBootTest(
    classes = SpringPersistentTestApp.class,
    properties = "spring.main.allow-bean-definition-overriding=true")
public abstract class JooqRepositoryTest {

  @Autowired protected DSLContext dslContext;
  @Autowired protected JooqMessageRepository messageRepository;
  @Autowired protected JooqRecipientRepository recipientRepository;
  @Autowired protected JooqTopicRepository topicRepository;
  @Autowired protected JooqSubscriptionRepository subscriptionRepository;

  public static final UUID ORGANIZATION_ID = UUID.randomUUID();

  protected final RSQLParser rsqlParser = new RSQLParser(ListFilteringOperators.all());

  @BeforeEach
  public void prepareDb() {
    dslContext.deleteFrom(Tables.MESSAGE).execute();
    dslContext.deleteFrom(Tables.SUBSCRIPTION).execute();
    dslContext.deleteFrom(Tables.RECIPIENT).execute();
    dslContext.deleteFrom(Tables.TOPIC).execute();
  }
}
