package sk.kosice.konto.kkmessageservice.restapi.dto.message;

import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.REQUIRED;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.immutables.value.Value;

@JsonDeserialize(as = ImmutableActionDto.class)
@JsonSerialize(as = ImmutableActionDto.class)
@Value.Immutable
public interface ActionDto {

  @Schema(requiredMode = REQUIRED)
  String getTitle();

  @Schema(requiredMode = REQUIRED)
  String getDescription();

  @Schema(requiredMode = REQUIRED)
  ActionType getType();

  String getValue();

  List<ActionPayMetadataDto> getMetadata();
}
