package sk.kosice.konto.kkmessageservice.business.topic.service;

import static sk.kosice.konto.kkmessageservice.domain.common.enumeration.Permission.ACTION_MANAGE_TOPIC;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kkmessageservice.business.AbstractService;
import sk.kosice.konto.kkmessageservice.business.permission.port.outbound.CheckPermissionsUseCase;
import sk.kosice.konto.kkmessageservice.business.topic.port.inbound.UpdateTopicUseCase;
import sk.kosice.konto.kkmessageservice.business.topic.port.outbound.PersistTopicPort;
import sk.kosice.konto.kkmessageservice.business.topic.port.outbound.QueryTopicPort;
import sk.kosice.konto.kkmessageservice.domain.topic.command.UpdateTopicCommand;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.ImmutableTopicEntity;
import sk.kosice.konto.kkmessageservice.domain.topic.entity.TopicEntity;
import sk.kosice.konto.kkmessageservice.domain.topic.query.FindTopicByIdQuery;

@Named
public class UpdateTopicService extends AbstractService implements UpdateTopicUseCase {

  private final PersistTopicPort persistTopicPort;
  private final QueryTopicPort queryTopicPort;
  private final CheckPermissionsUseCase checkPermissionsUseCase;

  @Inject
  public UpdateTopicService(
      PersistTopicPort persistTopicPort,
      QueryTopicPort queryTopicPort,
      CheckPermissionsUseCase checkPermissionsUseCase) {
    this.persistTopicPort = persistTopicPort;
    this.queryTopicPort = queryTopicPort;
    this.checkPermissionsUseCase = checkPermissionsUseCase;
  }

  @Override
  public TopicEntity execute(UpdateTopicCommand command) {
    checkPermission(
        checkPermissionsUseCase, command.actorId(), ACTION_MANAGE_TOPIC, command.organizationId());

    final var entity =
        queryTopicPort.findOne(FindTopicByIdQuery.of(command.id(), command.organizationId()));

    final TopicEntity data =
        ImmutableTopicEntity.builder()
            .id(entity.id())
            .name(command.name())
            .description(command.description())
            .organizationId(entity.organizationId())
            .organizationName(entity.organizationName())
            .build();

    persistTopicPort.update(data);
    return queryTopicPort.findOne(FindTopicByIdQuery.of(data));
  }
}
