package sk.kosice.konto.kkmessageservice.domain.message.entity;

import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.BodyType;
import sk.kosice.konto.kkmessageservice.domain.common.enumeration.Location;

@Value.Immutable
public interface MessageEntity extends BaseMessageEntity {

  String body();

  @Value.Default
  default Boolean isNotificationSend() {
    return false;
  }

  BodyType bodyType();

  String bodyShort();

  Optional<String> actions();

  List<Location> locations();
}
