package sk.kosice.konto.kknotificationservice.scheduler;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

import com.mailjet.client.MailjetRequest;
import com.mailjet.client.errors.MailjetException;
import org.junit.jupiter.api.Test;

public class SchedulerSendEmailJobFeatureSpec extends SchedulerFeatureSpec {

  @Test
  public void thatSendEmailJobIsWorking() throws MailjetException {
    setUpMailjet();
    prepareMessages();

    final var sendEmailsJob = new SendEmailsJob(findAndSendMessageWasNotSentUseCase);
    sendEmailsJob.sendPendingEmails();
    verify(mailjetClient, times(3)).post(any(MailjetRequest.class));

    final var messages = queryMessagePort.findNotSentMessages(100);
    assertThat(messages).isNotNull().hasSize(0);
  }
}
