package sk.kosice.konto.kkmessageservice.repository.provider;

import static sk.kosice.konto.kkmessageservice.repository.model.Tables.TOPIC;

import sk.kosice.konto.kkmessageservice.domain.common.listing.SubscriptionListingAttribute;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadata;
import sk.kosice.konto.kkmessageservice.repository.rsql.jooq.metadata.JooqRsqlMetadataConfigProvider;

public class SubscriptionJooqRsqlMetadataConfigProvider implements JooqRsqlMetadataConfigProvider {

  @Override
  public void configure(JooqRsqlMetadata metadata) {
    metadata
        .addColumnInfo(
            SubscriptionListingAttribute.ORGANIZATION_ID.apiName(), TOPIC.ORGANIZATION_ID)
        .addColumnInfo(
            SubscriptionListingAttribute.ORGANIZATION_NAME.apiName(), TOPIC.ORGANIZATION_NAME)
        .addColumnInfo(SubscriptionListingAttribute.TOPIC_ID.apiName(), TOPIC.ID)
        .addColumnInfo(SubscriptionListingAttribute.TOPIC_NAME.apiName(), TOPIC.NAME)
        .addColumnInfo(SubscriptionListingAttribute.TOPIC_DESCRIPTION.apiName(), TOPIC.DESCRIPTION);
  }
}
