package sk.kosice.konto.kkmessageservice.restapi.springdoc.restapi.springdoc;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import sk.kosice.konto.kkmessageservice.domain.common.listing.common.ListingAttribute;
import sk.kosice.konto.kkmessageservice.restapi.springdoc.restapi.springdoc.annotation.SortParameter;

@Component
public class SortParameterCustomizer implements ParameterCustomizer {

  @Override
  public Parameter customize(Parameter parameterModel, MethodParameter methodParameter) {
    SortParameter annotation = methodParameter.getParameterAnnotation(SortParameter.class);
    if (annotation != null) {
      parameterModel.description(
          parameterModel.getDescription()
              + "<b>Supported sort attributes:</b> "
              + prepareSortingAttributes(annotation.listingAttributeClass()));
      parameterModel.example(prepareSortingExample(annotation.listingAttributeClass()));
    }
    return parameterModel;
  }

  private static <E extends Enum & ListingAttribute> String prepareSortingAttributes(
      Class<? extends Enum<? extends ListingAttribute>> clazz) {
    try {
      final Method method = clazz.getDeclaredMethod("values");
      return Arrays.stream((E[]) method.invoke(true))
          .filter(ListingAttribute::isForSorting)
          .map(ListingAttribute::apiName)
          .collect(Collectors.joining(", "));
    } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
      return "";
    }
  }

  private static <E extends Enum & ListingAttribute> String prepareSortingExample(
      Class<? extends Enum<? extends ListingAttribute>> clazz) {
    try {
      final Method method = clazz.getDeclaredMethod("values");
      return Arrays.stream((E[]) method.invoke(true))
          .filter(ListingAttribute::isForSorting)
          .map(a -> a.apiName() + ";")
          .findFirst()
          .orElse("");
    } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
      return "";
    }
  }
}
