package sk.kosice.konto.kkmessageservice.repository.subscription;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Test;
import sk.kosice.konto.kkmessageservice.domain.subscription.entity.SubscriptionEntity;

public class JooqSubscriptionRepositoryInitizalizationTest extends JooqSubscriptionRepositoryTest {

  @Test
  public void thatSubscriptionsCanBeInitializedForRecipient() {
    prepareTopics();
    final UUID recipientKid = prepareRecipient();

    subscriptionRepository.initSubscriptionsForRecipient(recipientKid);
    final List<SubscriptionEntity> result = findSubscriptions(subscriptionRepository, recipientKid);

    assertThat(result).isNotNull().isNotEmpty().hasSize(3);
  }

  @Test
  public void thatSubscriptionsCanBeInsertedForNewTopic() {
    final var topicId = prepareTopics().getFirst();
    final UUID recipientKid = prepareRecipient();

    subscriptionRepository.createNewSubscriptionForEachRecipient(topicId);
    final List<SubscriptionEntity> result = findSubscriptions(subscriptionRepository, recipientKid);

    assertThat(result).isNotNull().isNotEmpty().hasSize(1);
    assertThat(result.getFirst().recipientKid()).isEqualTo(recipientKid);
    assertThat(result.getFirst().topic().id()).isEqualTo(topicId);
    assertThat(result.getFirst().isEmailEnabled()).isEqualTo(false);
  }
}
