package sk.kosice.konto.kkmessageservice.repository.subscription;

import static sk.kosice.konto.kkmessageservice.repository.model.Tables.RECIPIENT;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.SUBSCRIPTION;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.TOPIC;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import sk.kosice.konto.kkmessageservice.repository.JooqRepositoryTest;

public abstract class JooqSubscriptionRepositoryTest extends JooqRepositoryTest
    implements JooqSubscriptionRepositoryTestSupport {

  protected List<UUID> prepareTopics() {
    final var topic1 = UUID.randomUUID();
    final var topic2 = UUID.randomUUID();
    final var topic3 = UUID.randomUUID();
    var increment = 1;

    for (final var topic : List.of(topic1, topic2, topic3)) {
      dslContext
          .insertInto(TOPIC)
          .values(
              topic,
              "topic" + increment++,
              "topic" + increment++,
              ORGANIZATION_ID,
              "organizationName")
          .execute();
    }

    return List.of(topic1, topic2, topic3);
  }

  protected UUID prepareRecipient() {
    final var kid = UUID.randomUUID();

    dslContext.insertInto(RECIPIENT).values(kid, "test").execute();

    return kid;
  }

  protected List<UUID> prepareSubscriptions(UUID recipientId, UUID... topicIds) {
    List<UUID> ids = new ArrayList<>();

    for (final var topic : List.of(topicIds)) {
      var id = UUID.randomUUID();
      dslContext.insertInto(SUBSCRIPTION).values(id, topic, recipientId, false).execute();

      ids.add(id);
    }

    return ids;
  }
}
