package sk.kosice.konto.kkmessageservice.restapi.dto.topic;

import static io.swagger.v3.oas.annotations.media.Schema.RequiredMode.REQUIRED;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import org.immutables.value.Value;

@JsonDeserialize(as = ImmutableTopicDetailResponse.class)
@JsonSerialize(as = ImmutableTopicDetailResponse.class)
@Value.Immutable
public interface TopicDetailResponse extends BaseTopicDto {
  @Schema(requiredMode = REQUIRED, example = "0dc059b4-db1a-4692-9698-e32429b23bfe")
  UUID getId();

  @Schema(requiredMode = REQUIRED, example = "0dc059b4-db1a-4692-9698-e32429b23bfe")
  UUID getOrganizationId();
}
