package sk.kosice.konto.kkmessageservice.restapi.command;

import java.util.UUID;
import sk.kosice.konto.kkmessageservice.domain.common.audit.ImmutableActorIdentity;
import sk.kosice.konto.kkmessageservice.domain.topic.command.CreateTopicCommand;
import sk.kosice.konto.kkmessageservice.domain.topic.command.DeleteTopicCommand;
import sk.kosice.konto.kkmessageservice.domain.topic.command.ImmutableCreateTopicCommand;
import sk.kosice.konto.kkmessageservice.domain.topic.command.ImmutableDeleteTopicCommand;
import sk.kosice.konto.kkmessageservice.domain.topic.command.ImmutableUpdateTopicCommand;
import sk.kosice.konto.kkmessageservice.domain.topic.command.UpdateTopicCommand;
import sk.kosice.konto.kkmessageservice.restapi.dto.topic.TopicCreateRequest;
import sk.kosice.konto.kkmessageservice.restapi.dto.topic.TopicUpdateRequest;

public class TopicCommandFactory {

  public static CreateTopicCommand createTopicCommand(
      TopicCreateRequest request, UUID organizationId, String actorId) {
    return ImmutableCreateTopicCommand.builder()
        .name(request.getName())
        .description(request.getDescription())
        .organizationId(organizationId)
        .actorId(ImmutableActorIdentity.of(actorId))
        .build();
  }

  public static UpdateTopicCommand updateTopicCommand(
      TopicUpdateRequest request, UUID id, UUID organizationId, String actorId) {
    return ImmutableUpdateTopicCommand.builder()
        .name(request.getName())
        .description(request.getDescription())
        .organizationId(organizationId)
        .id(id)
        .actorId(ImmutableActorIdentity.of(actorId))
        .build();
  }

  public static DeleteTopicCommand deleteTopicCommand(
      UUID id, UUID organizationId, String actorId) {
    return ImmutableDeleteTopicCommand.builder()
        .organizationId(organizationId)
        .id(id)
        .actorId(ImmutableActorIdentity.of(actorId))
        .build();
  }
}
