package sk.kosice.konto.kkmessageservice.topic;

import sk.kosice.konto.kkmessageservice.restapi.dto.topic.ImmutableTopicCreateRequest;
import sk.kosice.konto.kkmessageservice.restapi.dto.topic.ImmutableTopicUpdateRequest;
import sk.kosice.konto.kkmessageservice.restapi.dto.topic.TopicUpdateRequest;

public final class TopicApiFixtures {

  public static ImmutableTopicCreateRequest createTopicRequest() {
    return createTopicRequest("name");
  }

  public static ImmutableTopicCreateRequest createTopicRequest(String name) {
    return ImmutableTopicCreateRequest.builder().name(name).description("description").build();
  }

  public static TopicUpdateRequest updateTopicRequest() {
    return ImmutableTopicUpdateRequest.builder()
        .name("nameUpdated")
        .description("descriptionUpdated")
        .build();
  }
}
