package sk.kosice.konto.kkmessageservice.domain.message.query;

import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Value;
import sk.kosice.konto.kkmessageservice.domain.common.marker.Query;
import sk.kosice.konto.kkmessageservice.domain.message.entity.MessageEntity;

@Deprecated
@Value.Immutable
public interface FindMessageByIdQuery extends Query {

  UUID id();

  Optional<UUID> recipientKid();

  static FindMessageByIdQuery of(UUID id) {
    return ImmutableFindMessageByIdQuery.builder().id(id).recipientKid(Optional.empty()).build();
  }

  static FindMessageByIdQuery of(UUID id, UUID recipientKid) {
    return ImmutableFindMessageByIdQuery.builder().id(id).recipientKid(recipientKid).build();
  }

  static FindMessageByIdQuery of(MessageEntity entity) {
    return ImmutableFindMessageByIdQuery.builder()
        .id(entity.id())
        .recipientKid(entity.recipientKid())
        .build();
  }
}
