'use client';

import React from 'react';
import { useBreakpoint } from '@/hooks';
import { ArrowDownwardIcon, ArrowUpwardIcon, DataGridRowValue, BaseButton } from '@/lib/idsk';

interface TopicsListHeaderProps {
  sort: 'asc' | 'desc';
  onSortChange: () => void;
}

const OrganizationsListHeader: React.FC<TopicsListHeaderProps> = ({ sort, onSortChange }) => {
  const { match, Breakpoints } = useBreakpoint();
  const isTablet = match(Breakpoints.tb2);

  return isTablet ? (
    <>
      <DataGridRowValue className="col-span-3">
        <BaseButton className="hover:underline flex items-center gap-2" onClick={onSortChange}>
          Názov {sort === 'desc' ? <ArrowUpwardIcon /> : <ArrowDownwardIcon />}
        </BaseButton>
      </DataGridRowValue>
      <DataGridRowValue className="col-span-6">Popis</DataGridRowValue>
      <DataGridRowValue align="right" className="col-span-3">
        Akcie
      </DataGridRowValue>
    </>
  ) : (
    <DataGridRowValue>Názov/Popis/Akcie</DataGridRowValue>
  );
};

export default OrganizationsListHeader;
