package sk.kosice.konto.kknotificationservice.repository.config;

import java.nio.file.Files;
import java.nio.file.Paths;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseDataSource;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value = "spring.liquibase.enabled", havingValue = "true")
public class LiquibaseConfiguration {

  public static final String LIQUIBASE_DATA_SOURCE = "LIQUIBASE_DATA_SOURCE";

  @Value("${spring.liquibase.url}")
  private String url;

  @Value("${spring.liquibase.user}")
  private String user;

  @Value("${spring.liquibase.password}")
  private String password;

  @Bean(name = LIQUIBASE_DATA_SOURCE)
  @LiquibaseDataSource
  DataSource dataSource() {
    return DataSourceBuilder.create()
        .url(url)
        .username(user)
        .password(resolvePassword(password))
        .build();
  }

  private String resolvePassword(String password) {
    try {
      return Files.readString(Paths.get(password)).trim();
    } catch (Exception ignored) {
      return password;
    }
  }
}
