package sk.kosice.konto.kknotificationservice.message;

import static sk.kosice.konto.kkmessageservice.repository.model.Tables.MESSAGE;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.RECIPIENT;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.TOPIC;

import java.time.OffsetDateTime;
import java.util.UUID;
import sk.kosice.konto.kknotificationservice.ServiceAppFeatureSpec;

public abstract class MessageFeatureSpec extends ServiceAppFeatureSpec {

  protected void prepareMessages() {
    final UUID kid = UUID.randomUUID();
    final UUID topicId = UUID.randomUUID();
    dslContext.insertInto(RECIPIENT).values(kid, "test@test.test").execute();
    dslContext
        .insertInto(TOPIC)
        .values(topicId, "topicName", "topicDesc", UUID.randomUUID(), "organizationName")
        .execute();
    dslContext
        .insertInto(MESSAGE)
        .values(
            UUID.randomUUID(),
            UUID.randomUUID(),
            UUID.randomUUID().toString(),
            "title1",
            topicId,
            "content1",
            "TEXT",
            "short",
            null,
            null,
            kid,
            OffsetDateTime.now(),
            false,
            "[\"KOSICE_BARCA\"]")
        .execute();
    dslContext
        .insertInto(MESSAGE)
        .values(
            UUID.randomUUID(),
            UUID.randomUUID(),
            UUID.randomUUID().toString(),
            "title2",
            topicId,
            "content2",
            "TEXT",
            "short",
            null,
            null,
            kid,
            OffsetDateTime.now(),
            false,
            "[\"KOSICE_BARCA\"]")
        .execute();
    dslContext
        .insertInto(MESSAGE)
        .values(
            UUID.randomUUID(),
            UUID.randomUUID(),
            UUID.randomUUID().toString(),
            "title3",
            topicId,
            "content3",
            "TEXT",
            "short",
            null,
            null,
            kid,
            OffsetDateTime.now(),
            true,
            "[\"KOSICE_BARCA\"]")
        .execute();
  }
}
