package sk.kosice.konto.kknotificationservice.mailjet.error.handler;

import static sk.kosice.konto.kknotificationservice.mailjet.error.MailjetClientErrorCode.MAILJET_CLIENT_BAD_REQEUEST;
import static sk.kosice.konto.kknotificationservice.mailjet.error.MailjetClientErrorCode.MAILJET_CLIENT_FORBIDDEN;
import static sk.kosice.konto.kknotificationservice.mailjet.error.MailjetClientErrorCode.MAILJET_CLIENT_INTERNAL_ERROR;
import static sk.kosice.konto.kknotificationservice.mailjet.error.MailjetClientErrorCode.MAILJET_CLIENT_UNAUTHORIZED;

import com.mailjet.client.MailjetResponse;

public class MailjetClientResponseHandler {

  public static void handleResponse(MailjetResponse response) {
    if (response.getStatus() > 0 && response.getStatus() < 400) {
      return;
    }

    if (response.getStatus() >= 400 && response.getStatus() < 500) {
      if (response.getStatus() == 401) {
        throw MAILJET_CLIENT_UNAUTHORIZED.createError().convertToException();
      } else if (response.getStatus() == 403) {
        throw MAILJET_CLIENT_FORBIDDEN.createError().convertToException();
      } else {
        throw MAILJET_CLIENT_BAD_REQEUEST
            .createError(response.getRawResponseContent())
            .convertToException();
      }
    } else {
      throw MAILJET_CLIENT_INTERNAL_ERROR
          .createError(response.getRawResponseContent())
          .convertToException();
    }
  }
}
