package sk.kosice.konto.kknotificationservice.mailjet.mapper;

import com.mailjet.client.MailjetRequest;
import com.mailjet.client.Resource;
import com.mailjet.client.enums.ApiAuthenticationType;
import com.mailjet.client.enums.ApiVersion;
import com.mailjet.client.resource.Emailv31;
import org.json.JSONArray;
import org.json.JSONObject;
import sk.kosice.konto.kknotificationservice.domain.email.command.SendEmailCommand;
import sk.kosice.konto.kknotificationservice.domain.shared.enumeration.EmailBodyType;

public class MailjetClientAdapterMapper {

  public static MailjetRequest map(SendEmailCommand sendEmailCommand) {
    final var messageRequest =
        new JSONObject()
            .put(
                Emailv31.Message.FROM,
                new JSONObject()
                    .put(Emailv31.Message.EMAIL, sendEmailCommand.senderInfo().email())
                    .put(Emailv31.Message.NAME, sendEmailCommand.senderInfo().name()))
            .put(Emailv31.Message.SUBJECT, sendEmailCommand.messageTitle());

    if (sendEmailCommand.messageBodyType().equals(EmailBodyType.TEXT)) {
      messageRequest.put(Emailv31.Message.TEXTPART, sendEmailCommand.messageBody());
    } else {
      messageRequest.put(Emailv31.Message.HTMLPART, sendEmailCommand.messageBody());
    }

    final JSONArray recipients = new JSONArray();
    sendEmailCommand
        .recipients()
        .forEach(
            recipient -> recipients.put(new JSONObject().put("Email", recipient).put("Name", "")));
    messageRequest.put(
        Emailv31.Message.TO,
        new JSONArray()
            .put(
                new JSONObject()
                    .put("Email", sendEmailCommand.senderInfo().email())
                    .put("Name", sendEmailCommand.senderInfo().name())));
    messageRequest.put(Emailv31.Message.BCC, recipients);

    return new MailjetRequest(
            new Resource("send", "", ApiVersion.V3_1, ApiAuthenticationType.Basic))
        .property(Emailv31.MESSAGES, new JSONArray().put(messageRequest));
  }
}
