package sk.kosice.konto.kknotificationservice.repository;

import org.jooq.DSLContext;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import sk.kosice.konto.kkmessageservice.repository.model.Tables;
import sk.kosice.konto.kknotificationservice.repository.message.JooqMessageRepository;
import sk.kosice.konto.kknotificationservice.repository.recipient.JooqRecipientRepository;

@ExtendWith(SpringExtension.class)
@SpringBootTest(
    classes = SpringPersistentTestApp.class,
    properties = "spring.main.allow-bean-definition-overriding=true")
public abstract class JooqRepositoryTest {

  @Autowired protected DSLContext dslContext;
  @Autowired protected JooqRecipientRepository recipientRepository;
  @Autowired protected JooqMessageRepository messageRepository;

  @BeforeEach
  public void prepareDb() {
    dslContext.deleteFrom(Tables.RECIPIENT).execute();
    dslContext.deleteFrom(Tables.MESSAGE).execute();
  }
}
