package sk.kosice.konto.kknotificationservice.scheduler;

import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import sk.kosice.konto.kknotificationservice.business.message.port.inbound.FindAndSendMessageWasNotSentUseCase;

@EnableScheduling
@Configuration
@EnableSchedulerLock(
    defaultLockAtMostFor = "${sk.kosice.notification.scheduler.default-lock-at-most-for}")
public class ScheduledJobs {

  @Bean
  @ConditionalOnProperty(
      value = {
        "sk.kosice.notification.scheduler.email-sender.enabled",
      },
      matchIfMissing = true,
      havingValue = "true")
  public SendEmailsJob publishMessagesJob(
      FindAndSendMessageWasNotSentUseCase findAndSendMessageWasNotSentUseCase) {
    return new SendEmailsJob(findAndSendMessageWasNotSentUseCase);
  }
}
