package sk.kosice.konto.kknotificationservice.recipient;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;
import static sk.kosice.konto.kkmessageservice.domain.common.error.ErrorCodeType.BAD_REQUEST;
import static sk.kosice.konto.kknotificationservice.recipient.RecipientApiFixtures.createOrUpdateRecipientRequest;

import java.util.UUID;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;
import sk.kosice.konto.kknotificationservice.restapi.dto.common.error.ErrorDetailResponse;
import sk.kosice.konto.kknotificationservice.restapi.dto.recipient.CreateOrUpdateRecipientRequest;
import sk.kosice.konto.kknotificationservice.restapi.dto.recipient.RecipientDetailResponse;

public class RecipientMergeFeatureSpec extends RecipientFeatureSpec {

  @Test
  public void thatRecipientCanBeCreated() {
    final UUID kid = UUID.randomUUID();
    final CreateOrUpdateRecipientRequest request = createOrUpdateRecipientRequest();
    final RecipientDetailResponse detailResponse = createOrUpdateRecipient(kid, request);

    assertThat(detailResponse.kid()).isEqualTo(kid);
    assertThat(detailResponse.getPreferredEmail()).isEqualTo(request.getPreferredEmail());
  }

  @Test
  public void thatRecipientCanBeUpdated() {
    final RecipientDetailResponse created =
        createOrUpdateRecipient(UUID.randomUUID(), createOrUpdateRecipientRequest());

    final CreateOrUpdateRecipientRequest updateRequest =
        createOrUpdateRecipientRequest().withPreferredEmail("peter.kosicky@icloud.com");

    final RecipientDetailResponse updated = createOrUpdateRecipient(created.kid(), updateRequest);

    assertThat(updated.kid()).isEqualTo(created.kid());
    assertThat(updated.getPreferredEmail()).isEqualTo(updateRequest.getPreferredEmail());
  }

  @Test
  public void thatRecipientInvalidEmailCannotBeUpdated() {
    final RecipientDetailResponse created =
        createOrUpdateRecipient(UUID.randomUUID(), createOrUpdateRecipientRequest());

    final CreateOrUpdateRecipientRequest updateRequest =
        createOrUpdateRecipientRequest().withPreferredEmail("peter*(*(%%^kosicky@icloudcom");

    final ErrorDetailResponse updated =
        createOrUpdateRecipient(
            created.kid(), updateRequest, HttpStatus.BAD_REQUEST, ErrorDetailResponse.class);

    assertThat(updated.primaryFault().get().faultCode()).isEqualTo(BAD_REQUEST.toString());
  }
}
